<?php
include("includes/header.php"); 
include("includes/sidebar.php"); 
?>


<div class="main-content app-content">
  <div class="container mt-3">
 
<div class="d-flex justify-content-between align-items-center mb-3 mt-3 p-4 rounded-4 shadow-sm text-white" 
     style="background: #C81D25;">
  
  <div>
    <h5 class="fw-bold mb-1 text-light">Apply For Withdraw</h5>
    <p class="mb-0 opacity-75">Withdraw your returns to your bank account.</p>
  </div>

  <div>
    <i class="bi bi-piggy-bank-fill" style="font-size: 2.5rem;"></i>
  </div>
</div>
      <!-- Left: Form -->
      <div id="responseMessage" class="mt-3"></div>
        <div class="card border-0 shadow-sm rounded-4">
          <div class="card-body">
            <h5 class="text-uppercase mb-4 fw-bold text-danger"> Make a Withdrawal</h5>
            <form method="POST" id="withdrawalForm">
              <?php echo $csrf->csrfInput(); ?>
              
              <input type="hidden" name="id" value="<?php echo $id; ?>">

              <div class="mb-3">
                <label class="form-label fw-semibold">Amount <span class="text-danger">*</span></label>
                <input type="number" class="form-control modern-input" name="amount" id="amount" placeholder="Enter deposit amount" required>
              </div>

              <div class="mb-3">
                <label class="form-label">Bank Name</label>
                <input type="text" class="form-control modern-input" name="bank" id="bank"  required>
              </div>

            

              <div class="mb-3">
                <label class="form-label fw-semibold">Account Number</label>
                <input type="text" class="form-control modern-input" id="acc_no" name="acc_no" value="" >
              </div>

              <div class="mb-3">
                <label class="form-label">Account Name</label>
                <input type="text" class="form-control modern-input" id="acc_name" name="acc_name" >
              </div>


              <div class="text-end">
                <button class="btn btn-red modern-btn px-4 py-2" type="submit" id="formBtn">Submit</button>
              </div>
            </form>
          </div>
        </div>
 

      <!-- Right: Summary Box -->
      
    
  </div>
</div>

<!-- jsPDF -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>

<script>
function formatCurrency(num) {
  return "₦" + Number(num).toLocaleString();
}


</script>

<?php include("includes/footer.php"); ?>

<script>
$(document).ready(function () {
  $("#withdrawalForm").on("submit", function (e) {
    e.preventDefault(); // Prevent page reload

    $.ajax({
      url: "process-withdrawal.php", // PHP handler
      type: "POST",
      data: $(this).serialize(), // Send form data
      dataType: "json",
      beforeSend: function () {
        $("#responseMessage").html("<div class='text-info'>Processing...</div>");
        $('#formBtn').prop('disabled', true);
      },
      success: function (response) {
         
          $("#csrf_token").val(response.token)
          $('#formBtn').prop('disabled', false);
          
        if (response.status === "success") {
          $("#responseMessage").html(
            "<div class='alert alert-success'>" + response.message + "</div>"
          );
          $("#fixedDepositForm")[0].reset(); // Reset form
        } else {
          $("#responseMessage").html(
            "<div class='alert alert-danger'>" + response.message + "</div>"
          );
        }
      },
      error: function () {
         
        $("#responseMessage").html(
          "<div class='alert alert-danger'>An error occurred. Please try again.</div>"
        );
      }
    });
  });
});
</script>

