<?php

include("includes/header.php"); 
include("includes/sidebar.php"); 

$loans = $db_handle->runBaseQuery("SELECT * FROM loan_application WHERE status = 0");

$date = date("d-m-Y h:i:sa");

if (isset($_GET['confirm'])) {
    
    $loanID = $_GET['confirm'];
    $userID = $_GET['user'];
    
    $row = $db_handle->runBaseQuery("SELECT * FROM loan_application WHERE id = $loanID");
    
    $amount = $row[0]['amount'];
    $interest = $row[0]['interest'];
    $repayment_date = $row[0]['repayment_date'];
    
   
    
    // check if user details already exists in database
    
    $user = $db_handle->runBaseQuery("SELECT * FROM users WHERE id = $userID ");
    
    $email = $user[0]['email'];
    $fname = $user[0]['first_name']." ".$user[0]['surname'];
    $balance = $user[0]['balance'];
    
    $email_message = '<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Loan Approved - Ovoh Initiative</title>
  <style>
    body {
      font-family: "Segoe UI", Tahoma, Geneva, Verdana, sans-serif;
      background-color: #f9f9f9;
      margin: 0;
      padding: 0;
    }
    .container {
      max-width: 600px;
      margin: 20px auto;
      background: #ffffff;
      padding: 20px;
      border-radius: 6px;
      border: 1px solid #e0e0e0;
      color: #333333;
    }
    .logo {
      text-align: center;
      margin-bottom: 15px;
    }
    .logo img {
      max-width: 180px;
      height: auto;
    }
    h2 {
      color: #28a745;
      text-align: center;
    }
    p {
      line-height: 1.5;
    }
    .details {
      background: #f4f4f4;
      padding: 10px;
      border-radius: 4px;
      margin: 15px 0;
      font-size: 14px;
    }
    .footer {
      font-size: 12px;
      color: #999999;
      text-align: center;
      margin-top: 20px;
    }
  </style>
</head>
<body>
  <div class="container">
    <div class="logo">
      <img src="https://app.ovohinitiative.com/asset/images/logo.png" alt="Ovoh Initiative Logo">
    </div>
    <h2>Loan Approved</h2>
    <p>Dear '.$fname.',</p>
    <p>Congratulations! We are pleased to inform you that your loan request has been approved. Below are the details of your approved loan:</p>
    
    <div class="details">
      <p><strong>Loan Amount:</strong> NGN'.number_format($loan_amount).'</p>
      <p><strong>Interest:</strong> '.$loan_id.'</p>
      <p><strong>Approval Date:</strong> '.$date.'</p>
      <p><strong>Repayment Due Date:</strong> '.$repayment_date.'</p>
    </div>

    <p>The approved amount has been credited to your account. Please ensure timely repayments to maintain a good credit history with us.</p>

    <p>You can view your loan status and repayment schedule by logging into your dashboard:</p>
    <p><a href="https://app.ovohinitiative.com/user/dashboard" style="color: #2c3e50;">https://app.ovohinitiative.com/user/dashboard</a></p>

    <p>If you have any questions, feel free to reach out to our support team:</p>
    <p>Email: <a href="mailto:support@ovohinitiative.com">support@ovohinitiative.com</a></p>

    <div class="footer">
      <p>This is an automated message. Please do not reply directly to this email.</p>
      <p>Ovohs Initiative | Warri, Delta State, Nigeria.</p>
    </div>
  </div>
</body>
</html>
';

$subject = "Loan Approved - Ovoh Initiative";
    
    
    
$db_handle->send_mail($email,$email_message,$subject);

        
       $upd =  $db_handle->update("UPDATE loan_application SET status = 1 WHERE id= ?", "i",array($loanID));

       if($upd){
           
          
        $url  = "pending-loans.php";
        echo '<META HTTP-EQUIV="refresh" content="3; URL='.$url.'">';  
        $msg = "<div class='alert alert-success text-center'> Payment verified successfully</div>";
        # code...
       }
        
    }

if(isset($_GET['decline'])){
    $id = $_GET['decline'];
    
    $row = $db_handle->runBaseQuery("SELECT * FROM loan_application WHERE id = $id");
    
    $amount = $row[0]['amount'];
    $userID = $row[0]['userID'];
   

    $user = $db_handle->runBaseQuery("SELECT * FROM users WHERE id = $userID ");
    
    $email = $user[0]['email'];
    $fname = $user[0]['first_name']." ".$user[0]['surname'];;
    
    $email_message = '<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Loan Declined - Ovoh Initiative</title>
  <style>
    body {
      font-family: "Segoe UI", Tahoma, Geneva, Verdana, sans-serif;
      background-color: #f9f9f9;
      margin: 0;
      padding: 0;
    }
    .container {
      max-width: 600px;
      margin: 20px auto;
      background: #ffffff;
      padding: 20px;
      border-radius: 6px;
      border: 1px solid #e0e0e0;
      color: #333333;
    }
    .logo {
      text-align: center;
      margin-bottom: 15px;
    }
    .logo img {
      max-width: 180px;
      height: auto;
    }
    h2 {
      color: #d9534f;
      text-align: center;
    }
    p {
      line-height: 1.5;
    }
    .details {
      background: #f4f4f4;
      padding: 10px;
      border-radius: 4px;
      margin: 15px 0;
      font-size: 14px;
    }
    .footer {
      font-size: 12px;
      color: #999999;
      text-align: center;
      margin-top: 20px;
    }
  </style>
</head>
<body>
  <div class="container">
    <div class="logo">
      <img src="https://app.ovohinitiative.com/asset/images/logo.png" alt="Ovoh Initiative Logo">
    </div>
    <h2>Loan Declined</h2>
    <p>Dear '.$fname.',</p>
    <p>We regret to inform you that your recent loan application could not be approved at this time. Below are the details of your application:</p>
    
    <div class="details">
      <p><strong>Requested Amount:</strong> NGN'.number_format($loan_amount).'</p>
      <p><strong>Application Date:</strong> '.$date.'</p>
    </div>

    <p>Unfortunately, your application did not meet the requirements for approval. You may reapply in the future after reviewing the necessary criteria or updating your details.</p>

    <p>You can check the status of your applications anytime by logging into your dashboard:</p>
    <p><a href="https://app.ovohinitiative.com/user/dashboard" style="color: #2c3e50;">https://app.ovohinitiative.com/user/dashboard</a></p>

    <p>If you would like further clarification, feel free to reach out to our support team:</p>
    <p>Email: <a href="mailto:support@ovohinitiative.com">support@ovohinitiative.com</a></p>

    <div class="footer">
      <p>This is an automated message. Please do not reply directly to this email.</p>
      <p>Ovohs Initiative | Warri, Delta State, Nigeria.</p>
    </div>
  </div>
</body>
</html>
';

$subject = "Loan Declined - Ovoh Initiative";
$db_handle->send_mail($email,$email_message,$subject);
    $sql = $db_handle->update("UPDATE loan_application SET status = ? WHERE id = ?","ii",array(2,$id));       
    $url  = "pending-loans.php";
    echo '<META HTTP-EQUIV="refresh" content="3; URL='.$url.'">';  
    $msg = "<div class='alert alert-success text-center'> Deposit has been declined.</div>";
}


 ?>
 <div class="main-content app-content">
 	<div class="container-fluid">
<div class="row mt-3">
            <div class="col-xl-12">
                <div class="card custom-card">
                    <div class="card-header justify-content-between border-bottom-0">
                        <div class="card-title"> All Loans </div>
                        
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table text-nowrap table-bordered" id="TableTab">
                                <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                       <th scope="col">Name</th>
                                       <th scope="col">Email</th>
                                        <th scope="col">Amount</th>
                                       <!-- <th scope="col">Payment Type</th> -->
                                        <th scope="col">Interest</th>
                                        <th scope="col">Date Applied</th>
                                        <th scope="col">Repayment Date</th>
                                        <th scope="col">Status</th>
                                        <th scope="col">Action</th>
                                       
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    if($loans){
                                        $i = 1;
                                    foreach($loans as $loan){
                                        
                                        $userID = $loan['userID'];
                                        $user = $db_handle->runBaseQuery("SELECT * FROM users WHERE id = $userID");
                                        
                                        $name = $user[0]['first_name']." ".$user[0]['surname'];
                                        $user_email = $user[0]['email'];
                                        if($loan['status'] == 0){
                                                $status = "PENDING";
                                            }elseif($loan['status'] == 1){
                                                $status = "APPROVED";
                                            }else{
                                                $status = "DECLINED";

                                            }
                                   echo "<tr>";
                                    echo '<td class="fw-medium">'.$i.'</td>';
                                    echo '<td class="fw-medium">'.$name.'</td>';
                                    echo '<td class="fw-medium">'.$user_email.'</td>';

                                      echo '<td class="fw-medium">NGN'.number_format($loan['amount']).'</td>';
                                        echo '<td> <span class="fw-medium">NGN'.number_format($loan['interest']).'</span></td>';
                                        
                                         echo '<td> <span class="">'.$loan['date'].'</span> </td>';
                                       
                                        echo '<td> <span class="">'.$loan['repayment_date'].'</span> </td>';
                                       
                                        
                                        echo '<td> <span class="">'.$status.'</span> </td>';

                                      /*  echo '<td>
                                            <div class="btn-list"> <button class="btn btn-sm btn-icon btn-success-light rounded-circle" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Edit"><i class="ri-pencil-line lh-1 align-middle"></i></button> <button class="btn btn-sm btn-icon btn-danger-light rounded-circle" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Delete"><i class="ri-delete-bin-line lh-1 align-middle"></i></button> </div>
                                        </td>';*/
                                        
                                        echo "<td class='tdSpace'>";
                                    echo "<a href=". "pending-loans?confirm=". $loan['id'] ."&user=".$loan['userID'].">";
                                    echo "<button class='bg-secondary text-white' style='font-size:0.85em;padding:5px 30px 2px 30px;outline:none;border:none'>";
                                    echo "<i class='fa fa-check-circle'></i> Confirm</button>";
                                    echo "</a>";
                                    echo " ";
                                    echo "<a href=". "pending-loans?decline=". $loan['id'].">";
                                    echo "<button class='bg-danger text-white' style='font-size:0.85em;padding:5px 30px 2px 30px;outline:none;border:none'>";
                                    echo "<i class='fa fa-times-circle'></i> Decline</button>";
                                    echo "</td>";
                                       
                                    echo '</tr>';

                                    $i++;
                                    
                                    }

                                }

                                ?>
                                    
                                   
                                   
                                </tbody>
                            </table>
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>
    </div>
 </div>
  <?php

include("includes/footer.php"); 
 ?>